timesteps = 500;  
h = 0.3;
alpha = 0.95;
h1 = h^alpha / gamma(1 + alpha);   

r = 2;
d = 0.2;
s = 0.4;  

x = zeros(1, timesteps+1);
y = zeros(1, timesteps+1);
x(1) = 0.31;          
y(1) = 2;     

for n = 1:timesteps
    x(n+1) = x(n) + h1 * ( r*x(n) - x(n)*y(n) );
    y(n+1) = y(n) + h1 * ( s - (1/r)*y(n) - d*x(n) + x(n)*y(n) );
end


t = (0:timesteps);

plot(t, x, '.r','markersize',8);
xlabel('n', 'FontSize', 14, 'FontWeight','bold');
ylabel('N(n)', 'FontSize', 14, 'FontWeight','bold');
set(gca, 'LineWidth', 1.5, 'FontSize', 12, 'FontWeight','bold');
